#include "TPM20CmdPack.h"

BOOLEAN packStartAuthSession(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER	*cmdHeader, T2P_HANDLE_AREA	*cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, T2T_SESSION_DEF_FILE *sDef, T2P_CONFIG_FILE *sCfg)
{

	UINT16 			u16Temp = 0;
	
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);	
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_StartAuthSession);	// 4
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sDef->tpmKey );
	cmdHandles->handle[1] = ChangeEndiannessDWord( sDef->bind );
	
	//no auth area
	cmdAuthArea->offset = 0;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//pack nonce
	PackNonce(cmdParamArea, sDef);
	
	//pack encrypted salt
	PackFSR2B_DATABUF(cmdParamArea, &sDef->encryptedSalt, sCfg);
	
	//pack sessionType - UINT8
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &sDef->sessionType, sizeof( sDef->sessionType ));
	cmdParamArea->offset += sizeof( sDef->sessionType );
	cmdParamArea->headroom -= sizeof( sDef->sessionType );
	
	//pack TPMT_SYM_DEF	symmetric;
	PackSymDef(cmdParamArea, &sDef->symmetric);
	
	//pack TPMI_ALG_HASH	authHashAlg; - UINT16
	u16Temp = ChangeEndiannessWord( sDef->authHashAlg );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &u16Temp, sizeof( sDef->authHashAlg ));
	cmdParamArea->offset += sizeof( sDef->authHashAlg );
	cmdParamArea->headroom -= sizeof( sDef->authHashAlg );
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// 4 bytes size 47

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
		
		
	return TRUE;
}

BOOLEAN packIndexDelete(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32	authSize = 9;
	UINT32	authSessionSize = 9;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_NV_UndefineSpace);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( iDef->hierarchy ); // handle from config file
	cmdHandles->handle[1] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex ); //session handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//pack auth info - UINT8
	cmdAuthArea->offset = 0;
	authSize = ChangeEndiannessDWord(authSize);
	CopyMem( &cmdAuthArea->buf[cmdAuthArea->offset], &authSize, sizeof( UINT32 ));
	cmdAuthArea->offset += sizeof( UINT32 );
	cmdAuthArea->headroom -= sizeof( UINT32 );
	
	//Print(L"sCfg->session[sessionNumber].sessionHandle: 0x%x\n", sCfg->session[sessionNumber].sessionHandle);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//calculate command side
	//Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	//Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	//Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	//Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	//Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packIndexDeleteSpecial(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 sessionNumber2)
{
	UINT32	authSessionSize = 9;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_NV_UndefineSpaceSpecial);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex); //
	cmdHandles->handle[1] = ChangeEndiannessDWord( iDef->hierarchy ); 
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//save room for the auth size updated later
	cmdAuthArea->offset = sizeof( UINT32 );
	
	//cmdAuthArea->headroom -= sizeof( UINT32 );
	
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );
	
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber2 );
	
	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//calculate command side
	//Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	//Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	//Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	//Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	//Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packIndexDefine(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{

	UINT32	authSessionSize;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_NV_DefineSpace);	// 4
	Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( iDef->hierarchy ); //session handle from config file
	//cmdHandles->handle[0] = sCfg->session[0].sessionHandle; //session handle from config file
	Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//Init the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//pack the param area	
	Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	PackFSR2B_DATABUF( cmdParamArea,  &iDef->auth, sCfg);
	
	PackFSR2B_NV_PUBLIC(cmdParamArea, &iDef->publicInfo, sCfg);
	
	//calculate command side
	Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packIndexWrite(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT32 handle0)
{

	UINT32	authSessionSize;
	UINT16	offset;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_NV_Write);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( handle0 ); //session handle from config file
	cmdHandles->handle[1] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex ); //session handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//Print(L"sCfg->session[sessionNumber].sessionHandle: 0x%x\n", sCfg->session[sessionNumber].sessionHandle);
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the ps policy buffer
	//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	PackFSR2B_DATABUF( cmdParamArea, &iDef->dataSource, sCfg);
	
	//pack the offset
	//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	offset = ChangeEndiannessWord( iDef->offset );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &offset, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);
	
	//calculate command side
	//Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	//Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	//Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	//Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	//Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packNvRead(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
	T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT32 handle0)
{

	UINT32	authSessionSize;
	UINT16	offset;
	UINT16	dataSize;
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	/*
	inputHeader.tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	inputHeader.commandSize = ChangeEndiannessDWord(sizeof(TPM20_NVRead_Index_In));
	inputHeader.commandCode = ChangeEndiannessDWord(TPM_CC_NV_Read);
	inputHeader.authHandle = ChangeEndiannessDWord(index);
	inputHeader.nvIndex = ChangeEndiannessDWord(index);
	inputHeader.authorizationSize = ChangeEndiannessDWord(9);
	inputHeader.sessionHandle = ChangeEndiannessDWord(TPM_RS_PW);
	inputHeader.sessionAttributes = 0;
	inputHeader.nonceSize = 0;
	inputHeader.passwordSize = 0;
	inputHeader.size = ChangeEndiannessWord(dataSize);
	inputHeader.offset = ChangeEndiannessWord(0);
	*/

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_NV_Read);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( handle0 ); //session handle from config file
	cmdHandles->handle[1] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex ); //session handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//Print(L"sCfg->session[sessionNumber].sessionHandle: 0x%x\n", sCfg->session[sessionNumber].sessionHandle);
	cmdAuthArea->offset = 0;
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//pack the datasize
	//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	dataSize = ChangeEndiannessWord( iDef->dataSource.buffer.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &dataSize, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);

	//pack the offset
	//Print(L"cmdParamArea->offset: %d\n", cmdParamArea->offset);
	offset = ChangeEndiannessWord( iDef->offset );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &offset, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);
	
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN assertPolicy(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 sessionNumber2) 
{

	switch(pDef->assertion) {
	
		case TPM_CC_PolicySigned:
			packPolicySigned(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicySecret:
			packPolicySecret(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber, sessionNumber2);
			break;
		case TPM_CC_PolicyTicket:
			break;
		case TPM_CC_PolicyOR:
			packPolicyOR(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyPCR:
			break;
		case TPM_CC_PolicyLocality:
			packPolicyLocality(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyNV:
			packPolicyNV(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyCounterTimer:
			break;
		case TPM_CC_PolicyCommandCode:
			packPolicyCommandCode(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyCpHash:
			packPolicyCpHash(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyNameHash:
			packPolicyNameHash(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyDuplicationSelect:
			break;
		case TPM_CC_PolicyAuthorize:
			packPolicyAuthorize(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case TPM_CC_PolicyNvWritten:
			packPolicyNvWitten(packedCmd, cmdHeader, cmdHandles, cmdAuthArea, cmdParamArea, pDef, sCfg, sessionNumber);
			break;
		case 0:	//T2T_POLA_NULL
			break;
		default:
			break;
	}

	return TRUE;
} 

BOOLEAN packPolicyLocality(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT8 			u8Locality = 0;
			
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyLocality);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//pack locality - UINT8
	CopyMem(&u8Locality, &pDef->T2TU_POL_PARAMS.paramsLOC.locality, 1);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &u8Locality, sizeof( u8Locality ));
	cmdParamArea->offset += sizeof( u8Locality );
	cmdParamArea->headroom -= sizeof( u8Locality );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyDigest(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2T_SESSION_DEF_FILE *sDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyGetDigest);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file
	//cmdHandles->handle[0] = sCfg->session[0].sessionHandle; //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	
	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyOR(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32 i = 0;
	UINT32 digestCount = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyOR);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//First pack the digest count
	Print(L"pDef->T2TU_POL_PARAMS.paramsOR.digestCount: %d\n", pDef->T2TU_POL_PARAMS.paramsOR.digestCount);
	digestCount = ChangeEndiannessDWord(pDef->T2TU_POL_PARAMS.paramsOR.digestCount);
	CopyMem( &cmdParamArea->buf[0], &digestCount, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );
	
	//then pack the digests
	for ( i = 0; i < pDef->T2TU_POL_PARAMS.paramsOR.digestCount; i++ ) {
		if( pDef->T2TU_POL_PARAMS.paramsOR.digests[i].buffer.bufType == DATA_BUFFER ) { //#define	DATA_BUFFER			0x01	// buffer contains the data
			PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsOR.digests[i], sCfg);

		} else if( pDef->T2TU_POL_PARAMS.paramsOR.digests[i].buffer.bufType == CONFIG_DIGEST ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			Pack2B( cmdParamArea, &sCfg->digest[pDef->T2TU_POL_PARAMS.paramsOR.digests[i].buffer.dataIndex] );

		} else if( pDef->T2TU_POL_PARAMS.paramsOR.digests[i].buffer.fileType == CONFIG_DIGEST ) { //#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
			PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsOR.digests[i], sCfg);
		}
	}
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyRestart(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyRestart);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyCpHash(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyCpHash);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//then packHash digest
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsCp.cpHashA, sCfg);
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyNameHash(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyNameHash);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//then packHash digest
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsName.nameHash, sCfg);
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyCommandCode(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32 i = 0;
	UINT32 commandCode = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyCommandCode);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//pack the command code
	commandCode = ChangeEndiannessDWord(pDef->T2TU_POL_PARAMS.paramsCC.code);
	CopyMem( &cmdParamArea->buf[0], &commandCode, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicySecret(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 sessionNumber2)
{
	UINT32 i = 0;
	UINT32 authSessionSize;
	UINT32 expiration = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicySecret);	// 4
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( pDef->T2TU_POL_PARAMS.paramsSecret.authObjHandle ); //authobjHandle is Aux index value 0x01800001
	cmdHandles->handle[1] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//save room for the auth size updated later
	cmdAuthArea->offset = sizeof(UINT32);
	
	//Use Password auth session (Session handle TPM_SE_PW 0x40000009) from second session for creating the branch
	//this atuh area doesn't get evaluated for the purpose of creating the branch
	//This section is evaluated when 
	//Print(L"sessionNumber2: %d\n", sessionNumber2);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber2 );
	
	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Pack the nonce TPM 
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSecret.nonceTPM, sCfg);
	//Pack the cpHashA
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSecret.cpHashA, sCfg);
	//Pack the policyRef
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSecret.policyRef, sCfg);
	
	//pack the expiration last
	expiration = ChangeEndiannessDWord(pDef->T2TU_POL_PARAMS.paramsSecret.expiration);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &expiration, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicySigned( T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber )
{
	UINT32 i = 0;
	UINT32 authSessionSize;
	UINT32 expiration = 0;
	UINT16 sigAlg = 0;
	UINT16 hashAlg = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicySigned);	// 4
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( pDef->T2TU_POL_PARAMS.paramsSign.authObject ); //authobjHandle is Aux index value 0x01800001
	cmdHandles->handle[1] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Pack the nonce TPM 
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSign.nonceTPM, sCfg);
	//Pack the cpHashA
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSign.cpHashA, sCfg);
	//Pack the policyRef
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSign.policyRef, sCfg);
	
	//pack the expiration 
	expiration = ChangeEndiannessDWord(pDef->T2TU_POL_PARAMS.paramsSign.expiration);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &expiration, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );
	
	//pack the sigAlg 
	sigAlg = ChangeEndiannessWord(pDef->T2TU_POL_PARAMS.paramsSign.auth.sigAlg);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &sigAlg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	//pack the hashAlg 
	hashAlg = ChangeEndiannessWord(pDef->T2TU_POL_PARAMS.paramsSign.auth.signature.hashAlg);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &hashAlg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	//Pack the policyRef
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsSign.auth.signature.signature, sCfg);
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyNV( T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber )
{
	UINT32 i = 0;
	UINT32 authSessionSize;
	UINT16 offset = 0;
	UINT16 operation = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyNV);	// 4
	
	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( pDef->T2TU_POL_PARAMS.paramsNV.authHandle ); //authobjHandle is Aux index value 0x01800001
	cmdHandles->handle[1] = ChangeEndiannessDWord( pDef->T2TU_POL_PARAMS.paramsNV.nvIndex ); //session handle from config file
	cmdHandles->handle[3] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//init auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//save room for the auth size updated later
	cmdAuthArea->offset = sizeof(UINT32);
	
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );
	
	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Pack the nonce TPM 
	PackFSR2B_DATABUF( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsNV.operandB, sCfg );
	
	//pack the offset 
	offset = ChangeEndiannessWord(pDef->T2TU_POL_PARAMS.paramsNV.offset);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &offset, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	//pack the operation 
	operation = ChangeEndiannessWord(pDef->T2TU_POL_PARAMS.paramsNV.operation);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &operation, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyAuthorize( T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber )
{
	UINT32 i = 0;
	UINT16 tag = 0;
	UINT32 hierarchy = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyNV);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Pack the approvedPolicy
	PackT2T_DATA( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsAuth.approvedPolicy, sCfg);
	//Pack the policyRef
	PackT2T_DATA( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsAuth.policyRef, sCfg);
	//Pack the keySign
	PackT2T_DATA( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsAuth.keySign, sCfg);
	//Pack the checkTicket
	PackT2T_DATA( cmdParamArea, &pDef->T2TU_POL_PARAMS.paramsAuth.checkTicket, sCfg);
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packPolicyNvWitten(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POLICY_DEF_FILE *pDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32 i = 0;
	UINT32 writtenSet = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyNvWritten);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); //session handle from config file

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//pack the command code
	writtenSet = pDef->T2TU_POL_PARAMS.paramsNvWritten.writtenSet;
	CopyMem( &cmdParamArea->buf[0], &writtenSet, sizeof( UINT8 ));
	cmdParamArea->offset += sizeof( UINT8 );
	cmdParamArea->headroom -= sizeof( UINT8 );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}


BOOLEAN packSetPrimaryPolicy(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_POL_SET_FILE *pSet, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32 i = 0;
	UINT32 authSessionSize;
	UINT16 alg = 0;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_SetPrimaryPolicy);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( pSet->hierarchy ); 
	

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//save room for the auth size updated later
	cmdAuthArea->offset = sizeof(UINT32);
	
	//Use Password auth session (Session handle TPM_SE_PW 0x40000009) from second session for creating the branch
	//this atuh area doesn't get evaluated for the purpose of creating the branch
	//This section is evaluated when 
	//Print(L"sessionNumber2: %d\n", sessionNumber2);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );
	
	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Pack the primary policy
	PackFSR2B_DATABUF( cmdParamArea, &pSet->digest, sCfg);
	
	
	//pack the alg last
	alg = ChangeEndiannessWord(pSet->alg);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &alg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packHierarchyChangeAuth(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT32 hierarchy, CHAR16 *dataFile )
{
	UINT32 i = 0;
	UINT32 authSessionSize = 2;
	UINT32 alg = 0;
	UINT8 rawData[256];
	UINT64 dataSize = 0;
	UINT16 dataSizeToPack = 0;
	
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_HierarchyChangeAuth);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( hierarchy ); //0x4000000C
	

	//no auth area
	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	
	//save room for the auth size updated later
	cmdAuthArea->offset = sizeof(UINT32);
	
	//Use Password auth session (Session handle TPM_SE_PW 0x40000009) from second session for creating the branch
	//this atuh area doesn't get evaluated for the purpose of creating the branch
	//This section is evaluated when 
	//Print(L"sessionNumber2: %d\n", sessionNumber2);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );
	
	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	
	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//Pack the new authorization secret
	readDatFile(rawData, &dataSize, dataFile);
	Print(L"dataSize: 0x%x\n", dataSize);
	//DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);
	dataSizeToPack = ChangeEndiannessWord( (UINT16)dataSize );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &rawData, dataSize);
	cmdParamArea->offset += dataSize;
	cmdParamArea->headroom -= dataSize;
	//Pack2B( cmdParamArea, &sCfg->digest[cfgIndexNumber] );
	
	//calculate command side
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2Clear(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32	authSessionSize;// = 9;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_Clear);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( 0x4000000C ); // handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//calculate command side
	//Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	//Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	//Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	//Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	//Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2ClearControl(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 OwnerClearDisable)
{
	UINT32	authSessionSize;// = 9;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_ClearControl);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( 0x4000000C ); // handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	cmdParamArea->buf[0] = OwnerClearDisable;
	cmdParamArea->offset += 1;
	cmdParamArea->headroom -= 1;
	//calculate command side
	//Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	//Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	//Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	//Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	//Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2DaLockReset(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber)
{
	UINT32	authSessionSize;// = 9;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_DictionaryAttackLockReset);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( TPM_RH_LOCKOUT ); // handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	//calculate command side
	//Print(L"sizeof(T2P_CMD_HEADER): %d\n", sizeof(T2P_CMD_HEADER) );
	//Print(L"(sizeof(UINT32) * cmdHandles.handeCount): %d\n", (sizeof(UINT32) * cmdHandles->handeCount) );
	//Print(L"cmdAuthArea.offset: %d\n", cmdAuthArea->offset );
	//Print(L"cmdParamArea.offset : %d\n", cmdParamArea->offset  );
	//Print(L"Total : 0x%x\n", sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset  );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

//not finished - requires the TPM create command
BOOLEAN packTPM2HMAC(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 *rawData, UINT64 dataSize )
{
	UINT32	authSessionSize;
	UINT16	dataSizeToPack;
	UINT16	hashAlg = TPM_ALG_SHA256;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_HMAC);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( 0x4000000C ); // handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	Print(L"dataSize: 0x%x\n", dataSize);
	//DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);
	dataSizeToPack = ChangeEndiannessWord((UINT16) dataSize );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], rawData, dataSize);
	cmdParamArea->offset += dataSize;
	cmdParamArea->headroom -= dataSize;

	//pack the hash algorithm
	hashAlg = ChangeEndiannessWord( hashAlg );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &hashAlg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2HashSequenceStart(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg )
{
	UINT16	authSessionSize = 0;
	UINT16	dataSizeToPack;
	UINT16	hashAlg = TPM_ALG_SHA256;
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_HashSequenceStart);	// 4
	
	//handle info
	cmdHandles->handeCount = 0;
	//cmdHandles->handle[0] = ChangeEndiannessDWord( 0x4000000C ); // handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT16);
	cmdParamArea->headroom -= sizeof( UINT16 );
	authSessionSize = ChangeEndiannessWord(authSessionSize);
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT16 ));
	/*
	cmdAuthArea->buf[cmdAuthArea->offset] = 0x0;
	cmdAuthArea->buf[cmdAuthArea->offset + 1] = 0x1;
	cmdAuthArea->buf[cmdAuthArea->offset + 2] = 0x2;
	cmdAuthArea->buf[cmdAuthArea->offset + 3] = 0x3;
	cmdAuthArea->buf[cmdAuthArea->offset + 4] = 0x4;
	cmdAuthArea->buf[cmdAuthArea->offset + 5] = 0x5;
	cmdAuthArea->buf[cmdAuthArea->offset + 6] = 0x6;
	cmdAuthArea->buf[cmdAuthArea->offset + 7] = 0x7;
	cmdAuthArea->buf[cmdAuthArea->offset + 8] = 0x8;
	cmdAuthArea->offset += 9;
	cmdParamArea->headroom -= 9;
	*/

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//pack the hash algorithm
	hashAlg = ChangeEndiannessWord( hashAlg );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &hashAlg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2HashSequenceUpdate(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 handleNumber, UINT8 *rawData, UINT64 dataSize )
{
	UINT32	authSessionSize = 9;
	//UINT32	authSessionSizePack = 0;
	UINT32	handle = 0;
	UINT8	sessionAtrributes = 0;
	UINT16	nonceSize = 0;
	UINT16	authSize = 0;
	UINT16	dataSizeToPack = 0;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_SequenceUpdate);	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->objHandle[handleNumber] ); // handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, 1 );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	Print(L"dataSize: 0x%x\n", dataSize);
	//DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);
	dataSizeToPack = ChangeEndiannessWord((UINT16) dataSize );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], rawData, dataSize);
	cmdParamArea->offset += dataSize;
	cmdParamArea->headroom -= dataSize;
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2HashSequenceComplete(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 handleNumber )
{
	UINT32	authSessionSize = 9;
	UINT32	handle = 0;
	UINT8	sessionAtrributes = 0;
	UINT16	nonceSize = 0;
	UINT16	authSize = 0;
	UINT16	dataSizeToPack = 0;
	UINT16	dataSize = 0;
	UINT32	hierarchy = TPM_RH_PLATFORM;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_SequenceComplete );	// 4
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->objHandle[handleNumber] ); // handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, 1 );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	
	Print(L"dataSize: 0x%x\n", dataSize);
	//DumpHexValue(L"rawData:", (UINT8 *)rawData, dataSize);
	dataSizeToPack = ChangeEndiannessWord((UINT16) dataSize );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	/*
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], rawData, dataSize);
	cmdParamArea->offset += dataSize;
	cmdParamArea->headroom -= dataSize;
	*/

	//ad the hierarchy
	hierarchy = ChangeEndiannessDWord( hierarchy );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &hierarchy, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2NVWriteLock(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT32 handle0 )
{
	UINT32 nvIndex = 0;
	UINT32	authSessionSize = 0;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_NV_WriteLock );	// 4
	
	/*
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); // handle from config file
	*/

	//handle info
	cmdHandles->handeCount = 2;
	cmdHandles->handle[0] = ChangeEndiannessDWord( handle0 ); //session handle from config file
	cmdHandles->handle[1] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex ); //session handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2NVChangeAuth(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_NV_DEF_FILE *iDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 authNumber )
{
	UINT32	authSessionSize = 0;
	UINT16	dataSizeToPack = 0;
	//UINT16	dataSize = 0;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_NV_ChangeAuth );	// 4
	
	/*
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle ); // handle from config file
	*/

	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex ); //session handle from config file
	//cmdHandles->handle[1] = ChangeEndiannessDWord( iDef->publicInfo.nvPublic.nvIndex ); //session handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//ad the nv index to lock
	dataSizeToPack = ChangeEndiannessWord( sCfg->authValue[authNumber].size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &sCfg->authValue[authNumber].buffer, sCfg->authValue[authNumber].size );
	cmdParamArea->offset += sCfg->authValue[authNumber].size;
	cmdParamArea->headroom -= sCfg->authValue[authNumber].size;
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2CreatePrimary(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_K_DEF_FILE *kDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber )
{
	UINT32	authSessionSize = 0;
	UINT16	dataSizeToPack = 0;
	UINT16	type = 0;
	UINT16	nameAlg = 0;
	UINT32	attributes = 0;

	//params
	UINT16	algorithm = 0;
	UINT16	keyBits = 0;
	UINT16	mode = 0;

	UINT16	scheme = 0;
	UINT16	details = 0;
	UINT32	exponent = 0;

	UINT32	i = 0;
	UINT32	pcrCount = 0;
	UINT16	pcrHash = 0;
	UINT8	sizeofSelect = 0;

	UINT32	result = 0;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_CreatePrimary );	// 4

	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( TPM_RH_PLATFORM ); //session handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//add TPM2B_SENSITIVE_CREATE - inSensitive
	//pack teh sensitive create structs size
	dataSizeToPack = ChangeEndiannessWord( kDef->inSensitive.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//pck the user auth size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inSensitive.sensitive.userAuth.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	result = CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->inSensitive.sensitive.userAuth.buffer.buffer, kDef->inSensitive.sensitive.userAuth.size );
	cmdParamArea->offset += kDef->inSensitive.sensitive.userAuth.size;
	cmdParamArea->headroom -= kDef->inSensitive.sensitive.userAuth.size;

	//pack the data(key) size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inSensitive.sensitive.data.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->inSensitive.sensitive.data.buffer.buffer, kDef->inSensitive.sensitive.data.size );
	cmdParamArea->offset += kDef->inSensitive.sensitive.data.size;
	cmdParamArea->headroom -= kDef->inSensitive.sensitive.data.size;

	//add TPM2B_PUBLIC - inPublic
	//pack the size of the inpublic
	dataSizeToPack = ChangeEndiannessWord( kDef->inPublic.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	type = ChangeEndiannessWord( kDef->inPublic.publicArea.type );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &type, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	nameAlg = ChangeEndiannessWord( kDef->inPublic.publicArea.nameAlg );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &nameAlg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//since attributes is 32 bits and it's in a strange struct we have to copy it first
	CopyMem( &attributes, &kDef->inPublic.publicArea.objectAttributes, sizeof( UINT32 ));
	attributes = ChangeEndiannessDWord( attributes );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &attributes, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );

	//pack the authpolicy size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inPublic.publicArea.authPolicy.size);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], & kDef->inPublic.publicArea.authPolicy.buffer, kDef->inPublic.publicArea.authPolicy.size );
	cmdParamArea->offset += kDef->inPublic.publicArea.authPolicy.size;
	cmdParamArea->headroom -= kDef->inPublic.publicArea.authPolicy.size;

	//pack the Parameter struct - RSA Params - symetric
	algorithm = ChangeEndiannessWord( kDef->inPublic.publicArea.parameters.rsaDetail.symmetric.algorithm);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &algorithm, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//since keyBits is 16 bits and it's in a strange struct we have to copy it first
	CopyMem( &keyBits, &kDef->inPublic.publicArea.parameters.rsaDetail.symmetric.keyBits, sizeof( UINT16 ));
	keyBits = ChangeEndiannessWord( keyBits );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &keyBits, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//since mode is 16 bits and it's in a strange struct we have to copy it first
	CopyMem( &mode, &kDef->inPublic.publicArea.parameters.rsaDetail.symmetric.mode, sizeof( UINT16 ));
	mode = ChangeEndiannessWord( mode );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &mode, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//pack the Parameter struct - RSA params - scheme
	scheme = ChangeEndiannessWord( kDef->inPublic.publicArea.parameters.rsaDetail.scheme.scheme);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &scheme, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	/*
	//if alg null then details field is omitted
	//since details is 16 bits and it's in a strange struct we have to copy it first
	CopyMem( &details, &kDef->inPublic.t.publicArea.parameters.rsaDetail.scheme.details, sizeof( UINT16 ));
	details = ChangeEndiannessWord( details );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &details, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	*/

	//pack the Parameter struct - RSA Params keybits
	keyBits = ChangeEndiannessWord( (UINT16) kDef->inPublic.publicArea.parameters.rsaDetail.keyBits);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &keyBits, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//pack the Parameter struct - RSA Params exponent
	exponent = ChangeEndiannessDWord( kDef->inPublic.publicArea.parameters.rsaDetail.exponent);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &exponent, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );

	//pack the Unique struct size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inPublic.publicArea.unique.rsa.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->inPublic.publicArea.unique.rsa.buffer, kDef->inPublic.publicArea.unique.rsa.size );
	cmdParamArea->offset += kDef->inPublic.publicArea.unique.rsa.size;
	cmdParamArea->headroom -= kDef->inPublic.publicArea.unique.rsa.size;

	//add TPM2B_DATA - outsideInfo
	dataSizeToPack = ChangeEndiannessWord( kDef->outsideInfo.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->outsideInfo.buffer, kDef->outsideInfo.size );
	cmdParamArea->offset += kDef->outsideInfo.size;
	cmdParamArea->headroom -= kDef->outsideInfo.size;

	//add TPML_PCR_SELECTION - creationPCR
	pcrCount = ChangeEndiannessWord( kDef->creationPCR.count );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &pcrCount, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );

	for ( i = 0; i < kDef->creationPCR.count; i++ ) {
		pcrHash = ChangeEndiannessWord( kDef->creationPCR.pcrSelections[i].hash );
		CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &pcrHash, sizeof( UINT16 ));
		cmdParamArea->offset += sizeof( UINT16 );
		cmdParamArea->headroom -= sizeof( UINT16 );

		sizeofSelect = kDef->creationPCR.pcrSelections[i].sizeofSelect;
		CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &sizeofSelect, sizeof( UINT8 ));
		cmdParamArea->offset += sizeof( UINT8 );
		cmdParamArea->headroom -= sizeof( UINT8 );

		//we only support sha 256 so this will be 32 bytes for now
		CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], kDef->creationPCR.pcrSelections[i].pcrSelect, 32 );
		cmdParamArea->offset += 32;
		cmdParamArea->headroom -= 32;
	}
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2Create(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_K_DEF_FILE *kDef, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 handleNumber )
{
	UINT32	authSessionSize = 0;
	UINT16	dataSizeToPack = 0;
	UINT16	type = 0;
	UINT16	nameAlg = 0;
	UINT32	attributes = 0;

	//params
	UINT16	algorithm = 0;
	UINT16	keyBits = 0;
	UINT16	mode = 0;

	UINT16	scheme = 0;
	UINT16	details = 0;
	UINT32	exponent = 0;

	UINT32	i = 0;
	UINT32	pcrCount = 0;
	UINT16	pcrHash = 0;
	UINT8	sizeofSelect = 0;

	UINT32	result = 0;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_Create );	// 4

	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->objHandle[handleNumber] ); //session handle from config file
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//add TPM2B_SENSITIVE_CREATE - inSensitive
	//pack teh sensitive create structs size
	dataSizeToPack = ChangeEndiannessWord( kDef->inSensitive.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//pck the user auth size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inSensitive.sensitive.userAuth.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	result = CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->inSensitive.sensitive.userAuth.buffer.buffer, kDef->inSensitive.sensitive.userAuth.size );
	cmdParamArea->offset += kDef->inSensitive.sensitive.userAuth.size;
	cmdParamArea->headroom -= kDef->inSensitive.sensitive.userAuth.size;

	//pack the data(key) size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inSensitive.sensitive.data.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->inSensitive.sensitive.data.buffer.buffer, kDef->inSensitive.sensitive.data.size );
	cmdParamArea->offset += kDef->inSensitive.sensitive.data.size;
	cmdParamArea->headroom -= kDef->inSensitive.sensitive.data.size;

	//add TPM2B_PUBLIC - inPublic
	//pack the size of the inpublic
	dataSizeToPack = ChangeEndiannessWord( kDef->inPublic.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	type = ChangeEndiannessWord( kDef->inPublic.publicArea.type );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &type, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	nameAlg = ChangeEndiannessWord( kDef->inPublic.publicArea.nameAlg );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &nameAlg, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//since attributes is 32 bits and it's in a strange struct we have to copy it first
	CopyMem( &attributes, &kDef->inPublic.publicArea.objectAttributes, sizeof( UINT32 ));
	attributes = ChangeEndiannessDWord( attributes );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &attributes, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );

	//pack the authpolicy size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inPublic.publicArea.authPolicy.size);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], & kDef->inPublic.publicArea.authPolicy.buffer, kDef->inPublic.publicArea.authPolicy.size );
	cmdParamArea->offset += kDef->inPublic.publicArea.authPolicy.size;
	cmdParamArea->headroom -= kDef->inPublic.publicArea.authPolicy.size;

	//pack the Parameter struct - RSA Params - symetric
	algorithm = ChangeEndiannessWord( kDef->inPublic.publicArea.parameters.rsaDetail.symmetric.algorithm);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &algorithm, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//since keyBits is 16 bits and it's in a strange struct we have to copy it first
	CopyMem( &keyBits, &kDef->inPublic.publicArea.parameters.rsaDetail.symmetric.keyBits, sizeof( UINT16 ));
	keyBits = ChangeEndiannessWord( keyBits );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &keyBits, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//since mode is 16 bits and it's in a strange struct we have to copy it first
	CopyMem( &mode, &kDef->inPublic.publicArea.parameters.rsaDetail.symmetric.mode, sizeof( UINT16 ));
	mode = ChangeEndiannessWord( mode );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &mode, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//pack the Parameter struct - RSA params - scheme
	scheme = ChangeEndiannessWord( kDef->inPublic.publicArea.parameters.rsaDetail.scheme.scheme);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &scheme, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	/*
	//if alg null then details field is omitted
	//since details is 16 bits and it's in a strange struct we have to copy it first
	CopyMem( &details, &kDef->inPublic.t.publicArea.parameters.rsaDetail.scheme.details, sizeof( UINT16 ));
	details = ChangeEndiannessWord( details );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &details, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	*/

	//pack the Parameter struct - RSA Params keybits
	keyBits = ChangeEndiannessWord( (UINT16) kDef->inPublic.publicArea.parameters.rsaDetail.keyBits);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &keyBits, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );

	//pack the Parameter struct - RSA Params exponent
	exponent = ChangeEndiannessDWord( kDef->inPublic.publicArea.parameters.rsaDetail.exponent);
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &exponent, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );

	//pack the Unique struct size and data
	dataSizeToPack = ChangeEndiannessWord( kDef->inPublic.publicArea.unique.rsa.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->inPublic.publicArea.unique.rsa.buffer, kDef->inPublic.publicArea.unique.rsa.size );
	cmdParamArea->offset += kDef->inPublic.publicArea.unique.rsa.size;
	cmdParamArea->headroom -= kDef->inPublic.publicArea.unique.rsa.size;

	//add TPM2B_DATA - outsideInfo
	dataSizeToPack = ChangeEndiannessWord( kDef->outsideInfo.size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &dataSizeToPack, sizeof( UINT16 ));
	cmdParamArea->offset += sizeof( UINT16 );
	cmdParamArea->headroom -= sizeof( UINT16 );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &kDef->outsideInfo.buffer, kDef->outsideInfo.size );
	cmdParamArea->offset += kDef->outsideInfo.size;
	cmdParamArea->headroom -= kDef->outsideInfo.size;

	//add TPML_PCR_SELECTION - creationPCR
	pcrCount = ChangeEndiannessWord( kDef->creationPCR.count );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &pcrCount, sizeof( UINT32 ));
	cmdParamArea->offset += sizeof( UINT32 );
	cmdParamArea->headroom -= sizeof( UINT32 );

	for ( i = 0; i < kDef->creationPCR.count; i++ ) {
		pcrHash = ChangeEndiannessWord( kDef->creationPCR.pcrSelections[i].hash );
		CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &pcrHash, sizeof( UINT16 ));
		cmdParamArea->offset += sizeof( UINT16 );
		cmdParamArea->headroom -= sizeof( UINT16 );

		sizeofSelect = kDef->creationPCR.pcrSelections[i].sizeofSelect;
		CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], &sizeofSelect, sizeof( UINT8 ));
		cmdParamArea->offset += sizeof( UINT8 );
		cmdParamArea->headroom -= sizeof( UINT8 );

		//we only support sha 256 so this will be 32 bytes for now
		CopyMem( &cmdParamArea->buf[cmdParamArea->offset ], kDef->creationPCR.pcrSelections[i].pcrSelect, 32 );
		cmdParamArea->offset += 32;
		cmdParamArea->headroom -= 32;
	}
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2LoadExternal(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					UINT32	hierarchy, UINT8 *inSensitive, UINT64 inSensitiveSize, UINT8 *outPublic, UINT64 dataSize )
{
	
	UINT16	inSensitiveSizePack = 0;
	UINT16	outPublicSizePack = 0;
	//UINT32	hierarchy = ChangeEndiannessDWord(0x4000000C);
	hierarchy = ChangeEndiannessDWord(hierarchy);
	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_LoadExternal );	// 4
	
	//handle info
	cmdHandles->handeCount = 0;

	inSensitiveSizePack = (UINT16) inSensitiveSize;
	outPublicSizePack = ChangeEndiannessWord( (UINT16) dataSize );

	//pack auth info - UINT8
	//cmdAuthArea->offset = sizeof(UINT32);
	//PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	//authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	//CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	cmdAuthArea->offset = 0;

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	if ( inSensitiveSize == 0 ) {
		//inSensitve is optional in the load external so we'll ommit it
		CopyMem( &cmdParamArea->buf[0], &inSensitiveSizePack, sizeof(UINT16) );
		cmdParamArea->offset += sizeof(UINT16);
		cmdParamArea->headroom -= sizeof(UINT16);
	} else {

		//pack the inSensitive struct into the params section
		CopyMem( &cmdParamArea->buf[0], inSensitive, inSensitiveSize );
		cmdParamArea->offset += inSensitiveSize;
		cmdParamArea->headroom -= inSensitiveSize;
	}


	//pack the outPublic struct into the params section
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &outPublicSizePack, sizeof(UINT16) );
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);

	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], outPublic, dataSize );
	cmdParamArea->offset += dataSize;
	cmdParamArea->headroom -= dataSize;

	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &hierarchy, sizeof(UINT32) );
	cmdParamArea->offset += sizeof(UINT32);
	cmdParamArea->headroom -= sizeof(UINT32);
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2Load(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT8 *inPrivate, UINT64 inPrivateSize, UINT8 *inPublic, UINT64 inPublicSize, UINT8 handleNumber, UINT8 sessionNumber )
{
	UINT32	authSessionSize = 0;

	//Start auth session command area
	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord( TPM_CC_Load );	// 4
	
	//handle of parent key; shall not be a reserved handle
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->objHandle[handleNumber] ); //session handle from config file

	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//pack the inPrivate struct into the params section
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], inPrivate, inPrivateSize );
	cmdParamArea->offset += inPrivateSize;
	cmdParamArea->headroom -= inPrivateSize;

	//pack the inPublic struct into the params section
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], inPublic, inPublicSize );
	cmdParamArea->offset += inPublicSize;
	cmdParamArea->headroom -= inPublicSize;
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2Execute(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2T_CDEF_FILE *cDef, T2P_CONFIG_FILE *sCfg, BOOLEAN sessions, UINT64 *sessionNumber )
{
	UINT32	authSessionSize = 0;
	UINT16	dataSizeToPack = 0;
	UINT8	i = 0;


	//Start auth session command area
	if (sessions) {
		cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	} else {
		cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	}

	cmdHeader->commandCode = ChangeEndiannessDWord(cDef->cmdCode);	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = cDef->numHandles;
	for ( i = 0; i < cDef->numHandles; i++ ) {
		if ( (0x80000000 <= cDef->handle[i]) && (cDef->handle[i] <= 0x80000009) ) {
			cmdHandles->handle[i] = ChangeEndiannessDWord( sCfg->objHandle[ (UINT8) cDef->handle[i] ] ); //session handle from config file
		} else {
			cmdHandles->handle[i] = ChangeEndiannessDWord( cDef->handle[i] ); //session handle from config file
		}
	}

	cmdAuthArea->offset = 0;
	if (sessions) {
		cmdAuthArea->offset = 0;
		cmdAuthArea->offset = sizeof(UINT32);
		PackAuthSession( cmdAuthArea, sCfg, (UINT8)sessionNumber[0] );

		//go back and fill the auth session size field in
		//Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
		authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
		CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	}

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//pack the raw data 
	for ( i = 0; i < cDef->numCommandParams; i++ ) {

		//Pack data bytes only
		if ( cDef->Cp[i].type == DATA_ONLY ) {//DATA_ONLY 0

			//pull data stright from cDef file
			if ( cDef->Cp[i].data.buffer.bufType == DATA_BUFFER ) { //DATA_BUFFER 1
				CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &cDef->Cp[i].data.buffer.buffer, cDef->Cp[i].data.buffer.size);
				cmdParamArea->offset += cDef->Cp[i].data.buffer.size;
			}

			//pull data from config file data section
			if ( cDef->Cp[i].data.buffer.bufType == NULL_BUFFER && cDef->Cp[i].data.buffer.fileType == CONFIG_DATA ) {
				CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &sCfg->data[i].buffer, sCfg->data[i].size);
				cmdParamArea->offset += cDef->Cp[i].data.buffer.size;
			}
		
		//Pack dataSize first then data bytes
		} else if ( cDef->Cp[i].type == SIZED_BUFFER ) { //pack the data with size field first SIZED_BUFFER 1
			//pull data stright from cDef file
			if ( cDef->Cp[i].data.buffer.bufType == DATA_BUFFER ) { //DATA_BUFFER 1
				UINT16 tempeSize = 0;
				//change endianness?
				tempeSize = ChangeEndiannessWord( cDef->Cp[i].data.buffer.size );
				CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &tempeSize, sizeof( UINT16 ));
				cmdParamArea->offset += sizeof(UINT16);
			
				CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &cDef->Cp[i].data.buffer.buffer, cDef->Cp[i].data.buffer.size);
				cmdParamArea->offset += cDef->Cp[i].data.buffer.size;
			}

			//pull data from config file data section
			if ( cDef->Cp[i].data.buffer.bufType == NULL_BUFFER && cDef->Cp[i].data.buffer.fileType == CONFIG_DATA ) {
				CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &sCfg->data[i].size, sizeof( UINT16 ));
				cmdParamArea->offset += sizeof(UINT16);
			
				CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &sCfg->data[i].buffer, sCfg->data[i].size);
				cmdParamArea->offset += cDef->Cp[i].data.buffer.size;
			}
		} else {
			Print(L"Unknown command parameter type.\n");
		}
	}

	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2HierarchyControl(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
					T2P_CONFIG_FILE *sCfg, UINT32 authhandle, UINT8 sessionNumber, UINT32 enableHierarchy, UINT8 hierarchyState)
{
	UINT32	authSessionSize;// = 9;
	UINT32	hierarchy = 0;

	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_SESSIONS);
	//Print(L"cmdHeader->tag: 0x%x\n", cmdHeader->tag);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_HierarchyControl );	// 4
	//Print(L"cmdHeader->commandCode: 0x%x\n", cmdHeader->commandCode);
	
	//handle info
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( authhandle ); // handle from config file
	//Print(L"cmdHandles->handle[0]: 0x%x\n", cmdHandles->handle[0]);
	//Print(L"cmdHandles->handle[1]: 0x%x\n", cmdHandles->handle[1]);
	
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;
	
	hierarchy = ChangeEndiannessDWord( enableHierarchy );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &hierarchy, sizeof(UINT32) );
	cmdParamArea->offset += sizeof(UINT32);
	cmdParamArea->headroom -= sizeof(UINT32);

	
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &hierarchyState, sizeof(UINT8) );
	cmdParamArea->offset += sizeof(UINT8);
	cmdParamArea->headroom -= sizeof(UINT8);
	
	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];
	
	return TRUE;
}

BOOLEAN packTPM2PolicyPCR(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber, UINT8 digestIndex )
{

	UINT32	authSessionSize;// = 9;
	UINT32	hierarchy = 0;

	UINT32	pcrCount = 1;

	//tpms_pcr_selection
	UINT16	hashAlg = 0xB;
	UINT8	pcrSelectArraySize = 3;
	UINT8	pcrSelect[3] = {0x00, 0x01, 0x00};

	//big endian values
	UINT16	BEdigestSize = 0;
	UINT32	BEpcrCount = 0;
	UINT16	BEhashAlg = 0;

	cmdHeader->tag = ChangeEndiannessWord(TPM_ST_NO_SESSIONS);
	cmdHeader->commandCode = ChangeEndiannessDWord(TPM_CC_PolicyPCR);	// 4
	
	cmdHandles->handeCount = 1;
	cmdHandles->handle[0] = ChangeEndiannessDWord( sCfg->session[sessionNumber].sessionHandle );

	cmdAuthArea->offset = 0;
	cmdAuthArea->headroom = AUTH_AREA_MAX;
	/*
	//pack auth info - UINT8
	cmdAuthArea->offset = sizeof(UINT32);
	PackAuthSession( cmdAuthArea, sCfg, sessionNumber );

	//go back and fill the auth session size field in
	Print(L"cmdAuthArea->offset: %d\n", cmdAuthArea->offset);
	authSessionSize = ChangeEndiannessDWord( cmdAuthArea->offset - sizeof( UINT32 ) );
	CopyMem( &cmdAuthArea->buf[0], &authSessionSize, sizeof( UINT32 ));
	*/

	//pack the param area
	cmdParamArea->offset = 0;
	cmdParamArea->headroom = CP_BUF_MAX;

	//pack the PCR digest size
	BEdigestSize = ChangeEndiannessWord( sCfg->digest[digestIndex].size );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &BEdigestSize, sizeof(UINT16) );
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);

	//pack the digest into the params section
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &sCfg->digest[digestIndex].buffer, sCfg->digest[digestIndex].size );
	cmdParamArea->offset += sCfg->digest[digestIndex].size;
	cmdParamArea->headroom -= sCfg->digest[digestIndex].size;

	//pack the PCR count 
	BEpcrCount = ChangeEndiannessDWord( pcrCount );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &BEpcrCount, sizeof(UINT32) );
	cmdParamArea->offset += sizeof(UINT32);
	cmdParamArea->headroom -= sizeof(UINT32);

	//pack the PCR hash alg 
	BEhashAlg = ChangeEndiannessWord( hashAlg );
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &BEhashAlg, sizeof(UINT16) );
	cmdParamArea->offset += sizeof(UINT16);
	cmdParamArea->headroom -= sizeof(UINT16);

	//pack the PCR size of select
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], &pcrSelectArraySize, sizeof(UINT8) );
	cmdParamArea->offset += sizeof(UINT8);
	cmdParamArea->headroom -= sizeof(UINT8);

	//pack the PCR select 
	CopyMem( &cmdParamArea->buf[cmdParamArea->offset], pcrSelect, pcrSelectArraySize );
	cmdParamArea->offset += pcrSelectArraySize;
	cmdParamArea->headroom -= pcrSelectArraySize;

	cmdHeader->commandSize = ChangeEndiannessDWord( sizeof(T2P_CMD_HEADER) + (sizeof(UINT32) * cmdHandles->handeCount) + cmdAuthArea->offset + cmdParamArea->offset );	// UINT32 - size 15
	//Print(L"cmdHeader.commandSize: 0x%x\n", cmdHeader->commandSize);

	packedCmd->header.size = sizeof(T2P_CMD_HEADER);
	packedCmd->header.address = cmdHeader;
	packedCmd->handles.size = sizeof(UINT32) * cmdHandles->handeCount;
	packedCmd->handles.address = &cmdHandles->handle[0];
	packedCmd->authArea.size = cmdAuthArea->offset;
	packedCmd->authArea.address = &cmdAuthArea->buf[0];
	packedCmd->paramBuf.size = cmdParamArea->offset;
	packedCmd->paramBuf.address = &cmdParamArea->buf[0];

	return TRUE;
}